<?php require_once(__DIR__ . '/title.php'); ?>
<form action="<?= admin_url('admin.php?page=' . self::PAGE_ID . '&form_id=' . $form->id, 'https') ?>" method="post">
    <input type="hidden" name="action" value="save_form">
    <input type="hidden" name="nonce" value="<?= wp_create_nonce(self::PLUGIN_KEY . '_form'); ?>">
    <div class="wrap">
        <div class="card" style="max-width:100%">
            <h2 class="title"><?= $this->translate('main'); ?></h2>
            <hr>

            <table class="form-table">
                <tbody>
                    <tr>
                        <th><?= $this->translate('send_amocrm'); ?></th>
                        <td>
                            <select name="<?= self::PLUGIN_KEY . '_form' ?>[status]">
                                <option value="1" <?= $status ? 'selected' : '' ?>><?= $this->translate('yes'); ?></option>
                                <option value="0" <?= !$status ? 'selected' : '' ?>><?= $this->translate('no'); ?></option>
                            </select>
                        </td>
                        <td></td>
                    </tr>

                    <tr>
                        <th><?= $this->translate('lead_name'); ?></th>
                        <td>
                            <input id="lead_name" type="text" name="<?= self::PLUGIN_KEY . '_form' ?>[lead_name]"
                                   value="<?= $lead_name ?>">
                        </td>
                        <td>
                            <div class="form_tags">
                                <span class="btn-xs btn-outline-primary"><?= implode('</span>, <span class="btn-xs btn-outline-primary">', $all_tags) ?></span>
                            </div>
                        </td>
                    </tr>

                    <tr>
                        <th><?= $this->translate('responsible_list'); ?></th>
                        <td>
                            <select class="chosen-select" name="<?= self::PLUGIN_KEY . '_form' ?>[responsible_list][]"
                                    multiple data-placeholder="<?= $this->translate('select'); ?>">
                                <?php foreach ($managers as $manager_id => $manager) { ?>
                                    <option value="<?= $manager_id ?>" <?= in_array($manager_id, $responsible_list) ? 'selected' : ''; ?>>
                                        <?= $manager; ?>
                                    </option>
                                <?php } ?>
                            </select>
                        </td>
                        <td></td>
                    </tr>

                    <tr>
                        <th><?= $this->translate('pipeline'); ?></th>
                        <td>
                            <select id="pipeline_id" name="<?= self::PLUGIN_KEY . '_form' ?>[pipeline_id]">
                                <?php foreach ($pipelines as $pipeline__id => $pipeline) { ?>
                                    <option value="<?= $pipeline__id ?>" <?= $pipeline__id == $pipeline_id ? 'selected' : ''; ?>>
                                        <?= $pipeline['name']; ?>
                                    </option>
                                <?php } ?>
                            </select>
                        </td>
                        <td></td>
                    </tr>

                    <tr>
                        <th><?= $this->translate('pipeline_status'); ?></th>
                        <td>
                            <div id="p_status">
                                <div class="pipeline_select_title no-select"></div>
                                <div class="dropdown-menu hidden">
                                    <ul class="pipeline_select_dropdown"></ul>
                                </div>
                                <input type="hidden" name="<?= self::PLUGIN_KEY . '_form' ?>[p_status]" value="">
                            </div>
                        </td>
                        <td></td>
                    </tr>

                    <tr>
                        <th><?= $this->translate('sale'); ?></th>
                        <td>
                            <input type="number" name="<?= self::PLUGIN_KEY . '_form' ?>[price]"
                                   value="<?= $price ?>" placeholder="<?= $this->translate('sale'); ?>">
                        </td>
                        <td></td>
                    </tr>
                </tbody>
            </table>

            <h2><?= $this->translate('form_fields'); ?></h2>
            <hr>
            <table class="form-table">
                <tbody>
                    <?php if ($form_fields) { ?>
                        <?php foreach ($form_fields as $form_field) { ?>
                            <tr>
                                <th><?= $form_field['label'] ?></th>
                                <td>
                                    <select name="<?= self::PLUGIN_KEY . '_form' ?>[fields][<?= $form_field['id'] ?>]" class="large-text">
                                        <option value="0"><?= $this->translate('not_selected'); ?></option>
                                        <?php foreach ($amo_fields as $field_id => $amoField) { ?>
                                            <option value="<?= $field_id ?>" <?= (isset($fields['fields'][$form_field['id']]) and $field_id === $fields['fields'][$form_field['id']]) ? 'selected' : '' ?>>
                                                <?= $amoField ?>
                                            </option>
                                        <?php } ?>
                                    </select>
                                </td>
                                <td></td>
                            </tr>
                        <?php } ?>
                    <?php } ?>
                </tbody>
            </table>

            <h2><?= $this->translate('system_fields'); ?></h2>
            <hr>
            <table class="form-table">
                <tbody>
                    <?php foreach ($this->translate('system_fields_arr') as $system_field_key => $custom_tag_name) { ?>
                        <tr>
                            <th><?= $custom_tag_name ?></th>
                            <td>
                                <select name="<?= self::PLUGIN_KEY . '_form' ?>[custom_tags][<?= $system_field_key ?>]" class="large-text">
                                    <option value="0" <?= (isset($fields['custom_tags'][$system_field_key]) and $fields['custom_tags'][$system_field_key] === '0') ? 'selected' : ''; ?>>
                                        <?= $this->translate('not_selected') ?>
                                    </option>
                                    <?php foreach ($amo_fields as $field_id => $amoField) { ?>
                                        <option value="<?= $field_id ?>" <?= (isset($fields['custom_tags'][$system_field_key]) and $field_id === $fields['custom_tags'][$system_field_key]) ? 'selected' : '' ?>>
                                            <?= $amoField ?>
                                        </option>
                                    <?php } ?>
                                </select>
                            </td>
                            <td></td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>

            <h2><?= $this->translate('tags_title'); ?></h2>
            <hr>
            <table class="form-table">
                <tbody>
                    <?php if (isset($tags)) { ?>
                        <?php foreach ($tags as $tag) { ?>
                            <tr>
                                <th></th>
                                <td>
                                    <input type="text" name="<?= self::PLUGIN_KEY . '_form' ?>[tags][]"
                                           value="<?= $tag ?>">
                                </td>
                                <td>
                                    <div class="button button-primary button-large removetag"><?= $this->translate('delete'); ?></div>
                                </td>
                            </tr>
                        <?php } ?>
                    <?php } ?>
                    <tr>
                        <th></th>
                        <td></td>
                        <td>
                            <div class="button button-primary button-large newtag" data-name="<?= self::PLUGIN_KEY ?>_form">
                                <?= $this->translate('add'); ?>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>

            <h2><?= $this->translate('task_title'); ?></h2>
            <hr>
            <table class="form-table">
                <tbody>
                    <tr>
                        <th><?= $this->translate('creat_task'); ?></th>
                        <td>
                            <select name="<?= self::PLUGIN_KEY . '_form' ?>[task][task_status]" class="large-text">
                                <option value="1" <?= $task['task_status'] ? 'selected' : ''; ?>><?= $this->translate('yes'); ?></option>
                                <option value="0" <?= !$task['task_status'] ? 'selected' : ''; ?>><?= $this->translate('no'); ?></option>
                            </select>
                        </td>
                        <td></td>
                    </tr>

                    <tr>
                        <th><?= $this->translate('task_type'); ?></th>
                        <td>
                            <select name="<?= self::PLUGIN_KEY . '_form' ?>[task][task_type]">
                                <?php foreach ($task_types as $task_type) { ?>
                                    <option value="<?= $task_type['id'] ?>" <?= $task_type['id'] == $task['task_type'] ? 'selected' : ''; ?>>
                                        <?= $task_type['name']; ?>
                                    </option>
                                <?php } ?>
                            </select>
                        </td>
                        <td></td>
                    </tr>

                    <tr>
                        <th><?= $this->translate('task_description'); ?></th>
                        <td>
                            <input id="task_text" type="text" name="<?= self::PLUGIN_KEY . '_form' ?>[task][task_text]" value="<?= $task['task_text'] ?>">
                        </td>
                        <td></td>
                    </tr>

                    <tr>
                        <th><?= $this->translate('task_completed_till'); ?></th>
                        <td>
                            <div class="two_rows">
                                <div>
                                    <input id="task_complete_till" type="text" name="<?= self::PLUGIN_KEY . '_form' ?>[task][task_complete_till]" value="<?= $task['task_complete_till'] ?>">
                                </div>
                                <div>
                                    <select name="<?= self::PLUGIN_KEY . '_form' ?>[task][task_complete_till_times]">
                                        <?php foreach ($this->translate('times') as $time_key => $time_ru) { ?>
                                            <option value="<?= $time_key ?>" <?= $time_key === $task['task_complete_till_times'] ? 'selected' : ''; ?>>
                                                <?= $time_ru ?>
                                            </option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                        </td>
                        <td></td>
                    </tr>
                </tbody>
            </table>

            <h2><?= $this->translate('note_title'); ?></h2>
            <hr>
            <table class="form-table">
                <tbody>
                    <tr>
                        <th><?= $this->translate('note_template'); ?></th>
                        <td>
                            <textarea id="note" name="<?= self::PLUGIN_KEY . '_form' ?>[note]"
                                      rows="15"><?= $note ?></textarea>
                        </td>
                        <td>
                            <div class="form_tags">
                                <span class="btn-xs btn-outline-primary"><?= implode('</span>, <span class="btn-xs btn-outline-primary">', $all_tags) ?></span>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>

            <h2><?= $this->translate('salesbot_title'); ?></h2>
            <hr>
            <table class="form-table">
                <tbody>
                    <tr>
                        <th><?= $this->translate('status'); ?></th>
                        <td>
                            <select name="<?= self::PLUGIN_KEY . '_form' ?>[salesbot][status]">
                                <option value="1" <?= $salesbot['status'] ? 'selected' : '' ?>><?= $this->translate('enabled'); ?></option>
                                <option value="0" <?= !$salesbot['status'] ? 'selected' : '' ?>><?= $this->translate('disabled'); ?></option>
                            </select>
                        </td>
                        <td></td>
                    </tr>

                    <tr>
                        <th><?= $this->translate('salesbot'); ?></th>
                        <td>
                            <select name="<?= self::PLUGIN_KEY . '_form' ?>[salesbot][id]">
                                <option value="0" <?= ($salesbot['id'] == 0) ? 'selected' : ''; ?>><?= $this->translate('not_selected'); ?></option>
                                <?php if ($bots) { ?>
                                    <?php foreach ($bots as $bot_id => $bot_name) { ?>
                                        <option value="<?= $bot_id ?>" <?= ($salesbot['id'] == $bot_id) ? 'selected' : ''; ?>>
                                            <?= $bot_name ?>
                                        </option>
                                    <?php } ?>
                                <?php } ?>
                            </select>
                        </td>
                        <td></td>
                    </tr>
                </tbody>
            </table>

            <h2><?= $this->translate('duplicate_control_title') ?></h2>
            <hr>
            <table class="form-table">
		        <tbody>

                    <tr>
                        <th><?= $this->translate('status') ?></th>
                        <td>
                            <select name="<?= self::PLUGIN_KEY . '_form' ?>[antidub][status]">
                                <option value="1" <?=  $antidub_status ? 'selected' : '' ?> ><?= $this->translate('enabled') ?></option>
                                <option value="0" <?= !$antidub_status ? 'selected' : '' ?> ><?= $this->translate('disabled') ?></option>
                            </select>
                        </td>
                        <td></td>
                    </tr>

                    <tr>
                        <th><?= $this->translate('duplicate_not_write') ?></th>
                        <td>
                            <select class="chosen-select" name="<?= self::PLUGIN_KEY . '_form' ?>[antidub][ignore][]" multiple data-placeholder="<?= $this->translate('select') ?>">
                                <?php foreach($antidub_fields as $field_id => $field_name){ ?>
                                <option value="<?= $field_id ?>" <?= ($ignore and in_array($field_id, $ignore)) ? 'selected' : '' ?>><?= $field_name ?></option>
                                <?php } ?>
                            </select>
                        </td>
                        <td><?= $this->translate('duplicate_select_fields_text') ?></td>
                    </tr>

                    <tr>
                        <th><?= $this->translate('reassign_responsible_title') ?></th>
                        <td>
                            <select class="chosen-select" name="<?= self::PLUGIN_KEY . '_form' ?>[antidub][change_responsible]">
                                <option value="1" <?=  $change_responsible ? 'selected' : '' ?> ><?= $this->translate('yes') ?></option>
                                <option value="0" <?= !$change_responsible ? 'selected' : '' ?> ><?= $this->translate('no') ?></option>
                            </select>
                        </td>
                        <td><?= $this->translate('reassign_responsible_text') ?></td>
                    </tr>
	
		        </tbody>
		    </table>

        </div>

        <br>
        <button type="submit" class="button button-primary button-large margin-left-0"><?= $this->translate('save'); ?></button>
    </div>
</form>

<script>
    var pipelines = <?= json_encode($pipelines, JSON_FORCE_OBJECT); ?>;
    var pipeline_id = <?= $pipeline_id ? $pipeline_id : 'false'; ?>;
    var pipeline_status = "<?= isset($fields['p_status']) ? $fields['p_status'] : 0; ?>";

    var delete_text = '<?= $this->translate('delete') ?>';
    var not_selected_text = '<?= $this->translate('not_selected') ?>';
    var unsortered_text = '<?= $this->translate('unsortered') ?>';
    var not_found_text = '<?= $this->translate('not_found') ?>';
</script>